/********************************************************************************************************
*
* File                : PCF8574.c
* Hardware Environment:	DVK501 && F320 EX
* Build Environment   : uVision3 V3.80 20100913
* Version             : 
* By                  : Su Wei Feng
*
*                                  (c) Copyright 2005-2010, WaveShare
*                                       http://www.waveshare.net
*                                          All Rights Reserved
*
*********************************************************************************************************/

#define _DVK501_F320_EX_

#include <c8051f320.h>
#include <ws_clock.h>
#include <ws_delay.h>
#include <ws_iic_port.h>
#include <ws_pcf8574.h>
#include <ws_lcd_st7920_port.h>

void main(void)
{
   	uchar wRdat;                // Test counter
	//uchar *rDdat;

   	PCA0MD &= ~0x40;            // Clear watchdog timer enable
   	clock_external();			// Set oscillator in external,the clock is 12M
	delay_ms(100);
   	Check_SDA();	
	XBR1 = 0x40;                // Enable crossbar and weak pull-ups
	SPI_Init();
	st7920LcdInit();
   	SMBus_Init();
	Enb_Interrupt(); 
   	
	showLine(0,0,lcd_buffer," PCF8574 Example");
	showLine(0,1,lcd_buffer," I2C->Parallel");
	showLine(0,2,lcd_buffer," Focus on LED");
	showLine(0,3,lcd_buffer," value");
	refreshLCD(lcd_buffer); 
	wRdat = 0;                  // Output data counter

   	while (1)
   	{
		/*Read_PCF8574(rDdat);  // Read data
		showLine(8,1,lcd_buffer,"%x2",*rDdat);
		refreshLCD(lcd_buffer);*/
		Write_PCF8574(wRdat);	// Write data
		showLine(8,3,lcd_buffer,"0x%x2",wRdat);
		refreshLCD(lcd_buffer); 
      	wRdat++;
      	delay_ms (1000);
   	}
}