SparkFun MLX90614 Arduino Library
========================================

![SparkFun Infrared Thermometer Evaluation Board](https://cdn.sparkfun.com//assets/parts/5/6/4/6/10740-01a.jpg)

[*SparkFun Infrared Thermometer Evaluation Board (SEN-10740)*](https://www.sparkfun.com/products/10740)

An Arduino library that interfaces with the MLX90614 non-contact infrared thermometer over a 2-wire, I2C-like interface (SMBus). 

Repository Contents
-------------------

* **/examples** - Example sketches for the library (.ino). Run these from the Arduino IDE.
* * **/src** - Source files for the library (.cpp, .h).
* **keywords.txt** - Keywords from this library that will be highlighted in the Arduino IDE.
* **library.properties** - General library properties for the Arduino package manager.

Documentation
--------------

* **[Installing an Arduino Library Guide](https://learn.sparkfun.com/tutorials/installing-an-arduino-library)** - Basic information on how to install an Arduino library.
* **[Product Repository](https://github.com/sparkfun/IR_Thermometer_Evaluation_Board-MLX90614)** - Main repository (including hardware files) for the Infrared Thermometer Evaluation Board.
* **[Hookup Guide](https://learn.sparkfun.com/tutorials/mlx90614-ir-thermometer-hookup-guide)** - Basic hookup guide for the Infrared Thermometer Evaluation Board.

Products that use this Library
---------------------------------

* [Infrared Thermometer Evaluation Board - MLX90614](https://www.sparkfun.com/products/10740)- A Arduino-compatible evaluation board for the MLX90614.
* [Infrared Thermometer - MLX90614 ](https://www.sparkfun.com/products/9570) -- The MLX90614 IC itself

Version History
---------------
* [V 1.0.0](https://github.com/sparkfun/SparkFun_MLX90614_Arduino_Library/tree/V_1.0.0) - Initial release

License Information
-------------------

This product is _**open source**_!

The **code** is released under the MIT license. See the included LICENSE file for more information.

Distributed as-is; no warranty is given.

- Your friends at SparkFun.
