/*
 * DS18B20Գ
 * 
 * ;ģԳ
 * 
 * 									ע
 * Huafeng Lin			2012/04/21			
 * Huafeng Lin			2012/04/21			޸
 * 
 */

#include <reg51.h>

#define uchar unsigned char

code unsigned char seg7code[]={0xc0,0xf9,0xa4,0xb0,0x99,0x92,0x82,0xf8,0x80,0x90,0xff}; 	//СĹܶ
code unsigned char seg7codeB[]={0x40,0x79,0x24,0x30,0x19,0x12,0x02,0x78,0x00,0x10,0xff}; 	//СĹܶ

sbit DQ=P3^6; 				//ݴ߽ӵƬӦ 
unsigned char tempL=0; 		//ȫֱ
unsigned char tempH=0; 
unsigned int sdata;			//¶ȵ
unsigned char xiaoshu1;		//Сһλ
unsigned char xiaoshu2;		//Сڶλ
unsigned char xiaoshu;		//λС
bit fg=1;        			//¶־

void delay(unsigned char i)
{
	for(i;i>0;i--);
}

void delay1(uchar i)
{
	uchar j,k; 
	for(j=i;j>0;j--)
		for(k=125;k>0;k--);
}

void Init_DS18B20(void) 
{
	unsigned char x=0;
	DQ=1; 					//DQø 
	delay(8); 				//ʱ
	DQ=0; 					//͸λ 
	delay(80); 				//ʱ>480us) 
	DQ=1; 					// 
	delay(5); 				//ȴ15~60us) 
	x=DQ; 					//Xֵжϳʼûгɹ18B20ڵĻX=0X=1 
	delay(20); 
}

//һֽ
ReadOneChar(void)  			//ȴӸ͵ƽ1usϣʹΪߵƽӶź
{
	unsigned char i=0; 		//ÿ̵ĳʱΪ60us֮1usϵĸߵƽָ
	unsigned char dat=0; 
	for (i=8;i>0;i--) 		//һֽ8λ 
	{
		DQ=1; 
		delay(1); 
		DQ=0;
		dat>>=1; 
		DQ=1; 
		if(DQ) 
		dat|=0x80; 
		delay(4);
	} 
	return(dat);
}

//дһֽ
void WriteOneChar(unsigned char dat) 
{ 
	unsigned char i=0; 		//ߴӸߵƽ͵ƽдʼźš15us֮ڽдλ͵ϣ
	for(i=8;i>0;i--) 		//15~60us߽֮вǸߵƽд1д0 
	{
		DQ=0; 				//ڿʼһдǰ1usϵĸߵƽָڡ 
		DQ=dat&0x01; 
		delay(5); 
		DQ=1; 
		dat>>=1;
	} 
	delay(4);
}

//¶ֵλtempL;λtempH;
void ReadTemperature(void) 
{ 
	Init_DS18B20(); 					//ʼ
	WriteOneChar(0xcc); 				//кŵĲ
	WriteOneChar(0x44); 				//¶ת
	delay(125); 						//תҪһʱ䣬ʱ 
	Init_DS18B20(); 					//ʼ
	WriteOneChar(0xcc); 				//кŵĲ 
	WriteOneChar(0xbe); 				//¶ȼĴͷֱֵΪ¶ȵĵλ͸λ 
	tempL=ReadOneChar(); 				//¶ȵĵλLSB
	tempH=ReadOneChar(); 				//¶ȵĸλMSB	
	if(tempH>0x7f)      				//λΪ1ʱ¶Ǹ
	{
		tempL=~tempL;					//תȡһ
		tempH=~tempH+1;       
		fg=0;      						//ȡ¶Ϊʱfg=0
	}
	sdata = tempL/16+tempH*16;      	//
	xiaoshu1 = (tempL&0x0f)*10/16; 		//Сһλ
	xiaoshu2 = (tempL&0x0f)*100/16%10;	//Сڶλ
	xiaoshu=xiaoshu1*10+xiaoshu2; 		//Сλ
}

//ʾ
void Led(unsigned int date)
{ 
	if(fg==1)
	{
		P2=0xfe;     			//P1.0=0ѡͨһλ
		P0=seg7code[date/10];  	//ʮλ
		delay1(5);
		P0=0xff;        		//
		
		P2=0xfd;     			//P1.1=0,ѡͨڶλλ
		P0=seg7codeB[date%10];
		delay1(5);
		P0=0xff;       			//
		
		P2=0xfb;     			//P1.3=0,ѡͨλСһλ
		P0=seg7code[xiaoshu1];
		delay1(5);
		P0=0xff;         		//
		
		P2=0xf7;     			//P1.3=0,ѡͨλСڶλ
		P0=seg7code[xiaoshu2];
		delay1(5);
		P0=0xff;       			//
	}
		
	if(fg==0)  					//¶Ϊʱʾ
	{
		P2=0xfe;     			//P1.0=0ѡͨһλ
		P0=seg7code[11];  		//ʾ
		delay1(5);
		P0=0xff;        		//
		
		P2=0xfd;     			//P1.1=0,ѡͨڶλʮλ
		P0=seg7code[date/10];
		delay1(5);
		P0=0xff;       			//
		
		P2=0xfb;     			//P1.3=0,ѡͨλλ
		P0=seg7codeB[date%10];
		delay1(5);
		P0=0xff;         		//
		
		P2=0xf7;     			//P1.3=0,ѡͨλСһλ
		P0=seg7code[xiaoshu1];
		delay1(5);
		P0=0xff;       			//
	}
}

main()
{
	while(1)
	{
		ReadTemperature();
		Led(sdata);
	}
}